* randcoords.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Generate random sampling coordinates";
* Generate n random coordinates along a c m transect;
data transect;
	* Sample size n;
	n = 20;
	* Multiplying by c gives a uniform random variable with a=0, b=c;
	c = 100;
	do i = 1 to n;
		x = c*ranuni(0);
		output;
	end;
	drop i;
run;
* Print coordinates;
proc print data=transect;
run;
* Generate n random coordinates within a 200 x 100 m area;
data coords;
	* Sample size n;
	n = 200;
	* Multiplying by c_x gives a uniform random variable with a=0, b=c_x;
	c_x = 200;
	* Multiplying by c_y gives a uniform random variable with a=0, b=c_y;
	c_y = 100;
	do i = 1 to n;
		x = c_x*ranuni(0);
		y = c_y*ranuni(0);
		output;
	end;
	drop i;
run;
* Print first 25 coordinates;
proc print data=coords(obs=25);
run;
* Show coordinates as a scatterplot;
proc gplot data=coords;
	plot y*x / vaxis=axis1 haxis=axis2;
	symbol1 v=dot c=red;
	axis1 order=(0 to 100 by 10) label=(height=2) value=(height=2) 
	width=3 major=(width=2) minor=none;
    axis2 order=(0 to 200 by 20) label=(height=2) value=(height=2) 
	width=3 major=(width=2) minor=none;
run;
quit;
